/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.ResourceLink;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;

import java.util.List;

/**
 *
 */
public class CreateTomcatResourceLinksStep extends TomcatStepBase implements Step {

	private List<ResourceLink> resources;

	public CreateTomcatResourceLinksStep(TomcatServer target, String label, TomcatWarMapping warMapping, List<ResourceLink> resources) {
		super(target, warMapping);
		this.resources = resources;
		setDescription("Create Global JNDI Resources based on " + label + " on Tomcat server " + server + " on context " + contextRoot);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			HostFile contextFile = s.getFile(getContextFilePathOnServer());
			ctx.logOutput("Creating JNDI Global definitions in context file " + contextFile.getPath() + " on " + server.getHost());
			TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
			contextFileUtils.addOrUpdateResources(resources);
			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

	public List<ResourceLink> getResources() {
		return resources;
	}
}
