/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingArchiveHostFileInputTransformer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

@SuppressWarnings("serial")
public abstract class TomcatDeploymentStepBase extends TomcatStepBase {

	protected NamedDeployableArtifact artifact;

	private Map<String, String> properties;
	private PlaceholderFormat placeholderFormat;

	protected TomcatDeploymentStepBase(TomcatServer server, TomcatWarMapping mapping) {
		super(server, mapping);
		this.artifact = mapping.getSource();
		this.properties = KeyValuePair.toMap(mapping.getKeyValuePairs());
		this.placeholderFormat = mapping.getPlaceholderFormat();
	}

	@Override
	protected void setDescription(String description) {
		if (this.properties != null && !properties.isEmpty()) {
			description += " while replacing property values using " + placeholderFormat;
		}
		super.setDescription(description);
	}

	protected String getArtifactTargetFileName() {
		checkArtifactIsWar();
		return artifact.getName() + ".war";
	}

	protected String getExplodedWarTargetFileName() {
		checkArtifactIsWar();

		if (isContextSet()) {
			return server.getDeployDirPath() + server.getHost().getFileSeparator() + contextRoot;
		} else {
			return server.getDeployDirPath() + server.getHost().getFileSeparator() + artifact.getName();
		}
	}

	protected String getDeployedArtifactPath() {
		return getArtifactDeploymentDirectory() + server.getHost().getFileSeparator() + getArtifactTargetFileName();
	}

	protected String getArtifactDeploymentDirectory() {
		if (!StringUtils.isBlank(mapping.getContextRoot()) && !StringUtils.isBlank(mapping.getAppBase())) {
			return mapping.getAppBase();
		} else {
			return server.getDeployDirPath();
		}
	}

	protected void checkArtifactIsWar() {
		if (!(artifact instanceof War))
			throw new IllegalArgumentException("Artifact " + artifact + " is not a WAR");

	}

	protected HostFileInputStreamTransformer getTransformer() {
		if (properties == null)
			return null;
		if (properties.isEmpty())
			return null;
		return new LenientTemplateResolvingArchiveHostFileInputTransformer(properties, placeholderFormat);
	}

}
