/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ResolutionException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.Set;

import static com.qrmedia.commons.validation.ValidationUtils.checkNotNull;

/**
 */
public class CiToXML<T> {
	private final Set<String> addedAttributes;
	private final Map<String,String> translation = Maps.newHashMap();
	private final BeanValueHandler handler;
	private final T instance;

	private final Object[] emptyArgs = new Object[0];

	public CiToXML( T instance, Element e) {
		this.instance = instance;
		handler = new XmlBeanValueHandler(e);
		addedAttributes = Sets.newHashSet("class");
	}

	public void process() {
		checkNotNull("All arguments must be non-null", instance);

		try {
			BeanInfo info = Introspector.getBeanInfo(instance.getClass());
			for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
				final String propertyName = pd.getName();

				if (pd.getReadMethod() == null) {
					continue;
				}

				if (isAlreadyAdded(propertyName)) {
					continue;
				}

				final Object value = pd.getReadMethod().invoke(instance, emptyArgs);
				final Class<?> type = pd.getPropertyType();
				if (type.isAssignableFrom(Integer.class) || "int".equals(type.toString())) {
					int iValue = (Integer) value;
					if (iValue > 0) {
						addAttribute(translate(propertyName), Integer.toString(iValue));
					}
				}
				if (type.isAssignableFrom(Long.class) || "long".equals(type.toString())) {
					long lValue = (Long) value;
					if (lValue > 0) {
						addAttribute(translate(propertyName), Long.toString(lValue));
					}
				}
				if (type.isAssignableFrom(String.class)) {
					String sValue = (String) value;
					if (StringUtils.isNotBlank(sValue)) {
						addAttribute(translate(propertyName), sValue);
					}
				}
				
				if (type.isAssignableFrom(Boolean.class) || "boolean".equals(type.toString())) {
					Boolean bValue = (Boolean) value;
					addAttribute(translate(propertyName), (bValue ? "true" : "false"));
				}
			}
		} catch (Exception e) {
			throw new ResolutionException("Error when process bean " + instance + " of class " + instance.getClass(), e);
		}
	}

	private boolean isAlreadyAdded(String propertyName) {
		for (String s : addedAttributes) {
			if (s.equals(propertyName))
				return true;
		}
		return false;

	}


	/**
	 * A property and a value to the final document.
	 * @param propertyName
	 * @param value
	 */
	public void addAttribute(String propertyName, String value) {
		if (isAlreadyAdded(propertyName))
			return;
		handler.addAttribute(propertyName, value);
		addedAttributes.add(propertyName);

	}

	/**
	 * Tell to translate the beanPropertyName to the given xmlPropertyName
	 * @param beanPropertyName
	 * @param xmlPropertyName
	 */
	public void addTranslation(String beanPropertyName, String xmlPropertyName) {
		translation.put(beanPropertyName,xmlPropertyName);
	}

	private String translate(String propertyName) {
		if (translation.containsKey(propertyName))
			return translation.get(propertyName);
		return propertyName;
	}
}
