/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.Hosted;
import com.xebialabs.deployit.ci.ListenServer;
import com.xebialabs.deployit.ci.LoadBalancedServerAware;
import com.xebialabs.deployit.ci.LoadBalancingProtocol;
import com.xebialabs.deployit.hostsession.HostSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TomcatServer
extends BaseConfigurationItem
implements Discoverable<TomcatServer>,
LoadBalancedServerAware,
Hosted {
    public static final int DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS = 3000;
    public static final ArrayList<LoadBalancingProtocol> SUPPORTED_PROTOCOLS = Lists.newArrayList((Object[])new LoadBalancingProtocol[]{LoadBalancingProtocol.AJP});
    @ConfigurationItemProperty(required=true, asContainment=true, label="Tomcat server host", description="Host on which the Tomcat server is running.")
    private Host host;
    @ConfigurationItemProperty(required=true, discoveryParam=true, size=ConfigurationItemProperty.Size.LARGE, label="Tomcat installation location", description="Place where Tomcat is installed such as /opt/apache-tomcat-6.0.24.")
    private String tomcatHome;
    @ConfigurationItemProperty(required=false, description="AJP Port for the Tomcat Server, default is 8009")
    private int ajpPort = 8009;
    @ConfigurationItemProperty(required=false, discoveryParam=true, label="Tomcat appBase", description="Tomcat appBase, ex webapps")
    private String appBase = "webapps";
    @ConfigurationItemProperty(required=false, discoveryParam=true, label="Tomcat service", description="Tomcat service, ex Catalina")
    private String service = "Catalina";
    protected static Logger logger = Logger.getLogger(TomcatServer.class);

    public abstract TomcatServer discover(Map<String, Object> var1, ChangePlan var2);

    public abstract TomcatServer discoverChildrenInfo(Map<String, Object> var1, ChangePlan var2);

    public abstract boolean isManaged();

    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    public String getDeployDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + this.appBase;
    }

    public String getContextWithoutVirtualHostDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "conf" + fileSep + this.service + fileSep + "localhost";
    }

    public String getContextWithVirtualHostDirPath(String virtualHostName) {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "conf" + fileSep + this.service + fileSep + virtualHostName;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getTomcatHome() {
        return this.tomcatHome;
    }

    public void setTomcatHome(String tomcatHome) {
        this.tomcatHome = tomcatHome;
    }

    public int getAjpPort() {
        return this.ajpPort == 0 ? 8009 : this.ajpPort;
    }

    public void setAjpPort(int ajpPort) {
        this.ajpPort = ajpPort;
    }

    public String getTomcatLibDirectory() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getTomcatHome() + fileSep + "lib";
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        this.appBase = appBase;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public List<LoadBalancingProtocol> getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public List<ListenServer> getLoadBalancedServers(LoadBalancingProtocol protocol) {
        switch (protocol) {
            case AJP: {
                ListenServer server = new ListenServer();
                server.setLabel(this.getLabel());
                server.setHost(this.getHost());
                server.setListenPort(this.getAjpPort());
                return Lists.newArrayList((Object[])new ListenServer[]{server});
            }
        }
        return Lists.newArrayList();
    }
}

