/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;

public class TomcatUndeployApplicationStep
extends TomcatDeploymentStepBase {
    public TomcatUndeployApplicationStep(TomcatUnmanagedServer oldTarget, TomcatWarMapping mapping) {
        super(oldTarget, mapping);
        this.setDescription("Undeploy WAR file " + mapping.getSource() + " from Tomcat server " + (Object)((Object)oldTarget));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.server.connectToAdminHost();
        try {
            HostFile targetDeployFile = rhs.getFile(this.getDeployedArtifactPath());
            ctx.logOutput("Removing application artifact from " + targetDeployFile.getPath() + " on " + this.server.getHost());
            targetDeployFile.delete();
            String explodedWarDirectoryName = this.getExplodedWarTargetFileName();
            HostFile targetExplodedWar = rhs.getFile(explodedWarDirectoryName);
            if (targetExplodedWar.exists()) {
                ctx.logOutput("Removing application exploded directory " + targetExplodedWar.getPath() + " on " + this.server.getHost());
                targetExplodedWar.deleteRecursively();
            }
            if (this.isContextSet()) {
                HostFile contextFile = rhs.getFile(this.getContextFilePathOnServer());
                contextFile.delete();
            }
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

