/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = NoSelfReference.Validator.class, type = "no-self-reference")
@Target(ElementType.TYPE)
public @interface NoSelfReference {
    
    String referenceField();
    
    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<ConfigurationItem> {

        private String referenceField;
        
        @Override
        public void validate(ConfigurationItem value, ValidationContext context) {
            final String id = value.getId();
            Collection<ConfigurationItem> property = value.getProperty(referenceField);
            for (ConfigurationItem configurationItem : property) {
                if (configurationItem.getId().equals(id)) {
                    context.error("%s [%s] cannot contain a reference to itself.", value.getType(), id);
                    break;
                }
            }
        }
    }
}
