/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.HashSet;
import java.util.Set;

@PublicApiRef
@Metadata(virtual = true, description = "Base type for all provisioneds that are containers.")
public class BaseProvisionedContainer<D extends Provisionable, C extends Container> extends BaseDeployedContainer<D, C> implements Provisioned<D, C> {

    @Property(description = "The index of the cardinality amount created provisioneds.", required = false, category = "Output", hidden = true, defaultValue = "1")
    @DeployedSpecific
    private int ordinal = 1;

    private Set<String> tags = new HashSet<>();

    public BaseProvisionedContainer() {
    }

    @Override
    public Set<String> getTags() {
        return tags;
    }

    @Override
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getOrdinal() {
        return ordinal;
    }

}
