/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.deployit.plugin.api.reflect.Type;

import java.io.Serializable;
import java.util.List;

/**
 * Base interface of all configuration item types.
 * <p/>
 * Do not directly implement this class, instead extend {@link com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem} or one of the types
 * derived from it (e.g. {@link com.xebialabs.deployit.plugin.api.udm.base.BaseDeployable}, {@link com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed}
 * or {@link com.xebialabs.deployit.plugin.api.udm.base.BaseContainer}).
 * <p/>
 * The following contract is required: - The Type of a ConfigurationItem should be stored in a field called 'type'.
 */
@PublicApiRef
public interface ConfigurationItem extends Serializable {

    static final String TYPE_FIELD = "type";
    static final String SYNTHETIC_PROPERTIES_FIELD = "syntheticProperties";

    /**
     * @return The id of the CI.
     */
    String getId();

    /**
     * Sets The id of the CI.
     */
    void setId(String id);

    /**
     * @return The name of the CI.
     */
    String getName();

    /**
     * @return The type metadata for this CI.
     */
    Type getType();

    /**
     * @param key The name of the property.
     * @param <T> The type of the property.
     * @return The value of type T of the property.
     */
    <T> T getProperty(String key);

    /**
     * @param key The name of the property.
     * @return True if the CI has a added property with the given name.
     */
    boolean hasProperty(String key);

    /**
     * Adds a custom property of a generic type to the CI.
     *
     * @param key   The name of the property.
     * @param value The value of type T of the property.
     * @param <T>   The type of the property.
     */
    <T> void setProperty(String key, T value);

    /**
     * Gets the validation messages set on the ConfigurationItem.
     * @return a List&lt;ValidationMessage&gt;
     */
    List<ValidationMessage> get$validationMessages();

    /**
     * @return The internal ID of ConfigurationItem.
     */
    Integer get$internalId();

    /**
     * @return The ID of secured CI which determines ConfigurationItem's permissions.
     */
    Integer get$securedCi();

    /**
     * @return The UUID of ConfigurationItem's directory.
     */
    String get$directoryReference();
}
