/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.ArrayList;
import java.util.List;

@PublicApiRef
@Metadata(virtual = true, description = "Base type for all provisioneds.")
public class BaseProvisioned<D extends Provisionable, C extends Container> extends BaseDeployed<D, C> implements Provisioned<D, C> {

    @Property(description = "The index of the cardinality amount created provisioneds.", required = false, category = "Output", hidden = true, defaultValue = "1")
    @DeployedSpecific
    private int ordinal = 1;

    @Property(description = "A list of provisioners associated with the instance.", asContainment = true, category = "Provisioning")
    private List<AppliedProvisioner> provisioners = new ArrayList<>();

    public BaseProvisioned() {
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getOrdinal() {
        return ordinal;
    }

}
