/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.artifact;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Artifacts are files containing application resources such as code or images. The following are examples of artifacts:
 * <ul>
 *     <li>a WAR file.</li>
 *     <li>an EAR file.</li>
 *     <li>a folder containing static content such as HTML pages or images.</li>
 * </ul>
 */
@PublicApiRef
@TypeIcon("icons/types/udm.Artifact.svg")
public interface Artifact extends ConfigurationItem {

    /**
     * @return A representation of a file that can be access through an Overthere connection.
     */
    OverthereFile getFile();

    /**
     * @param file A representation of a file that can be access through an Overthere connection.
     */
    void setFile(OverthereFile file);

}
