/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.deployment.specification;

import java.io.Serializable;
import java.util.List;

/**
 * The specification of what needs to be deployed including application dependencies.
 */
public interface DeltaSpecificationWithDependencies extends Serializable {

    /**
     * Returns list of all delta specifications. Dependencies are specified first and main delta specification is last.
     *
     * @return all delta specifications.
     */
    List<DeltaSpecification> getAllDeltaSpecifications();

    /**
     * Returns list of all delta specifications grouped by the dependency index from the main application.
     * Dependency Index for a direct dependency is 1 , i.e direct dependencies are placed in the first list and so on.
     * Main delta specification is last in the List of Lists.
     *
     * @return all delta specifications.
     */
    List<List<DeltaSpecification>> getAllGroupedDeltaSpecifications();
}
