/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.HashMap;
import java.util.Map;

@PublicApiRef
public abstract class BaseDescriptorRegistry
implements IDescriptorRegistry {
    private final Map<String, Type> NAME_TYPE_CACHE = new HashMap<String, Type>();
    private final Map<Class<?>, Type> CLASS_TYPE_CACHE = new HashMap();
    private final DescriptorRegistryId id;

    protected BaseDescriptorRegistry(DescriptorRegistryId id) {
        if (id == null) {
            throw new NullPointerException("The id of a DescriptorRegistry cannot be null.");
        }
        this.id = id;
    }

    @Override
    public Type lookupType(Class<?> ciClass) {
        if (ciClass == null) {
            throw new NullPointerException("Type name may not be null");
        }
        if (this.CLASS_TYPE_CACHE.containsKey(ciClass)) {
            return this.CLASS_TYPE_CACHE.get(ciClass);
        }
        Package ciPackage = ciClass.getPackage();
        Prefix prefix = ciPackage.getAnnotation(Prefix.class);
        if (prefix == null) {
            throw new NullPointerException(String.format("Package [%s] should have an @Prefix annotation for ci-class [%s]", ciPackage.getName(), ciClass.getName()));
        }
        String simpleName = ciClass.getSimpleName();
        if (simpleName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not get a typename for ci-class [%s]", ciClass.getName()));
        }
        Type type = this.lookupType(prefix.value(), simpleName);
        this.CLASS_TYPE_CACHE.put(ciClass, type);
        return type;
    }

    @Override
    public Type lookupType(String typeName) {
        if (typeName == null) {
            throw new NullPointerException("Type name may not be null");
        }
        if (this.NAME_TYPE_CACHE.containsKey(typeName)) {
            return this.NAME_TYPE_CACHE.get(typeName);
        }
        if (typeName.indexOf(46) == -1) {
            throw new IllegalArgumentException(String.format("Type %s does not contain a prefix", typeName));
        }
        int indexOfLastDot = typeName.lastIndexOf(46);
        Type t = this.lookupType(typeName.substring(0, indexOfLastDot), typeName.substring(indexOfLastDot + 1));
        this.NAME_TYPE_CACHE.put(typeName, t);
        return t;
    }

    @Override
    public Type lookupType(String prefix, String simpleName) {
        return new Type(prefix, simpleName, this.id);
    }

    @Override
    public DescriptorRegistryId getId() {
        return this.id;
    }

    @Override
    public void verifyTypes() {
    }
}

