/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.flow;

import java.io.Serializable;

/**
 * An preview of the script that a step is going to execute, or of the template that will be copied.
 */
@SuppressWarnings("serial")
public final class Preview implements Serializable {

    private String sourcePath;

    private String contents;

    private Preview(String contents) {
        this.contents = contents;
    }

    public static Preview withContents(String contents) {
        return new Preview(contents);
    }

    public static Preview withSourcePathAndContents(String sourcePath, String contents) {
        Preview p = new Preview(contents);
        p.setSourcePath(sourcePath);
        return p;
    }

    /**
     * Returns the path of the source of the rendered content, e.g. a script or a FreeMarker template on the classpath.
     *
     * @return the path of the source or <code>null</code> if that information is not known.
     */
    public String getSourcePath() {
        return sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    /**
     * Returns a preview of the script that will be executed or the template that will be copied.
     *
     * This will be displayed in the GUI using a fixed-width font.
     *
     * @return The preview.
     */
    public String getContents() {
        return contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }
}
