/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.io.Serializable;

@PublicApiRef
public final class Type
implements Serializable {
    private String prefix;
    private String name;
    private DescriptorRegistryId typeSource;

    Type(String prefix, String name, DescriptorRegistryId id) {
        if (prefix == null || name == null) {
            throw new NullPointerException("Either prefix or name is null, type should be fully qualified.");
        }
        this.prefix = prefix;
        this.name = name;
        this.typeSource = id;
    }

    public static Type valueOf(Class<?> ciClass) {
        return DescriptorRegistry.getDefaultDescriptorRegistry().lookupType(ciClass);
    }

    public static Type valueOf(String typeName) {
        return DescriptorRegistry.getDefaultDescriptorRegistry().lookupType(typeName);
    }

    public static Type valueOf(String prefix, String simpleName) {
        return DescriptorRegistry.getDefaultDescriptorRegistry().lookupType(prefix, simpleName);
    }

    public Descriptor getDescriptor() {
        return DescriptorRegistry.getDescriptor(this);
    }

    public boolean isSubTypeOf(Type superType) {
        return DescriptorRegistry.getSubtypes(superType).contains(this);
    }

    public boolean instanceOf(Type selfOrSuperType) {
        return this.equals(selfOrSuperType) || DescriptorRegistry.getSubtypes(selfOrSuperType).contains(this);
    }

    public boolean isSuperTypeOf(Type subType) {
        return DescriptorRegistry.getSubtypes(this).contains(subType);
    }

    public boolean exists() {
        try {
            IDescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry(this);
            return registry != null && registry.exists(this);
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type1 = (Type)o;
        return this.prefix.equals(type1.prefix) && this.name.equals(type1.name);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.prefix + "." + this.name;
    }

    public DescriptorRegistryId getTypeSource() {
        return this.typeSource;
    }
}

