/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.IDictionary;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.transformer.PatchDictionary;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Metadata(description="Groups infrastructure CIs and dictionaries and serves as a target for deployment.", root=Metadata.ConfigurationItemRoot.ENVIRONMENTS)
@TypeIcon(value="icons/types/udm.Environment.svg")
@PublicApiRef
public class Environment
extends BaseConfigurationItem {
    @Property(required=false, label="Containers", description="The infrastructure components of this Environment")
    private Set<Container> members = new HashSet<Container>();
    @Property(required=false, description="The dictionaries providing placeholder values. If the same entry exists in multiple dictionaries, the first one in the list is taken.")
    private List<IDictionary> dictionaries = new ArrayList<IDictionary>();
    @Property(description="The directory path where the provisioned environment and provisioned configuration items will be stored.", required=false, category="Provisioning")
    private String directoryPath = null;
    @Property(required=false, description="List of patch dictionaries that apply changes on the deployables.")
    private List<PatchDictionary> patchDictionaries = new ArrayList<PatchDictionary>();

    public Environment() {
    }

    public Environment(Container ... members) {
        HashSet<Container> memberSet = new HashSet<Container>();
        Collections.addAll(memberSet, members);
        this.setMembers(memberSet);
    }

    public Set<Container> getMembers() {
        return this.members;
    }

    public <T extends Serializable> Set<T> getMembersOfType(Class<T> classType) {
        HashSet<Container> matchingMembers = new HashSet<Container>();
        for (Container member : this.getMembers()) {
            if (!classType.isInstance(member)) continue;
            matchingMembers.add(member);
        }
        return matchingMembers;
    }

    public void setMembers(Set<Container> members) {
        this.members = members;
    }

    public void addMember(Container member) {
        if (member == null) {
            throw new NullPointerException("Cannot add a null member");
        }
        this.members.add(member);
    }

    public List<IDictionary> getDictionaries() {
        return this.dictionaries;
    }

    public void setDictionaries(List<IDictionary> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public List<PatchDictionary> getPatchDictionaries() {
        return this.patchDictionaries;
    }

    public void setPatchDictionaries(List<PatchDictionary> patchDictionaries) {
        this.patchDictionaries = patchDictionaries;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }
}

