/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.overthere.OverthereFile;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A folder artifact that can be deployed")
public class BaseDeployableFolderArtifact extends BaseDeployableArtifact implements FolderArtifact {

    public List<OverthereFile> getFiles() {
        List<OverthereFile> files = new ArrayList<>();
        OverthereFile folderLocation = getFile();
        if (folderLocation.exists() && folderLocation.isDirectory() && folderLocation.canRead()) {
            List<? extends OverthereFile> allFiles = folderLocation.listFiles();
            if (allFiles != null) {
                files.addAll(allFiles);
            }
        }
        return files;
    }

}
