/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.rules;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
/**
 * Annotation that marks a step to be registered in the Step Registry and make it available to the Rules Engine.
 */
public @interface StepMetadata {

    /**
     * Name of the step as used in xml 'xl-rules.xml'. In Python scripts, use underscores '_' instead of dashes '-'.
     *
     * @return name of the step.
     */
    String name();

}
