/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployable;

import java.util.Set;

/**
 * A Container that is deployable to (provisioned on) a target platform.
 */
@PublicApiRef
@SuppressWarnings("serial")
@Metadata(virtual = true, description = "The base supertype for a deployable container.")
public class BaseDeployableContainer extends BaseDeployable implements DeployableContainer {

    @Property(required = false, category = "Deployment", description = "The tags to copy to the Deployed Container")
    private Set<String> containerTags;

    public Set<String> getContainerTags() {
        return containerTags;
    }

    public void setContainerTags(Set<String> containerTags) {
        this.containerTags = containerTags;
    }
}
