/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Base type for all provisioners. It is an embedded configuration item i.e it will always be
 * contained in another configuration item and can't be created as a top level deployable in
 * a provisioning package. Every provisioner should contain a host template that will be created
 * during the deployment and the host created will be provisioned by this provisioner.
 */
@PublicApiRef
@TypeIcon("icons/types/udm.Provisioner.svg")
public interface Provisioner extends EmbeddedDeployable {

    Template getHostTemplate();

}
