/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.lang.annotation.*;

/**
 * A creator is a method that can be invoked when a ConfigurationItem is created.
 * For instance, create other CIs based on an artifact.
 *
 * <p>A @Creator method should adhere to the following rule:
 * <ul>
 *     <li>it must be static</li>
 *     <li>take a <code>{@code CreatorContext}</code>. The CreatorContext provides methods to create, update or delete CIs.</li>
 *     <li>Optional: A Map of attributes</li>
 * </ul>
 */
@PublicApiRef
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Inherited
public @interface Creator {

}
