/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.lang.annotation.*;

/**
 * A CandidateValuesFilter can augment the {@link com.xebialabs.deployit.plugin.api.services.SearchParameters} for a ConfigurationItem search.
 * <p/>
 * A @CandidateValuesFilter method should adhere to the following rules:
 * <ul>
 *     <li>The method should be static</li>
 *     <li>The method should take 2 parameters:
 *     <ol>
 *         <li>The {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem} that is the context</li>
 *         <li>The {@link com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor} that the filter should be based on.</li>
 *     </ol>
 *     <li>The method should return a new {@link com.xebialabs.deployit.plugin.api.services.SearchParameters}</li>
 * </ul>
 */
@PublicApiRef
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Inherited
public @interface CandidateValuesFilter {

    /**
     * @return The name of the filter
     */
    String name();
}
