/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.lookup;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.HashMap;
import java.util.Map;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, description = "A LookupValueProvider that stores values in the database.")
@PublicApiRef
public class SimpleLookupValueProvider extends BaseConfigurationItem implements LookupValueProvider {

    @Property(description = "The lookup value entries", required = false)
    protected Map<String, String> entries = new HashMap<>();

    @Property(description = "The encrypted lookup value entries", required = false, password = true)
    protected Map<String, String> encryptedEntries = new HashMap<>();

    @Property(description = "Allow encrypted entries for non password properties.", defaultValue = "false")
    protected boolean allowEncryptedForNonPassword = false;

    @Override
    public String lookup(String key, boolean password) throws Exception {
        if (entries.containsKey(key)) {
            return entries.get(key);
        } else {
            if (encryptedEntries.containsKey(key)) {
                if (!(password || allowEncryptedForNonPassword))
                    throw new IllegalArgumentException("Will not provide an encrypted value for a non-password field.");
                return  encryptedEntries.get(key);
            }
        }
        return null;
    }
}

