/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.reflect.Verify;

@Verify(clazz = IsControlTaskParameters.Validator.class, type="isControlTaskParameters")
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface IsControlTaskParameters {

    public static class Validator implements TypeVerification {
        @Override
        public void verify(Descriptor descriptor, VerificationContext context) {
            Type type = descriptor.getType();
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                validate(!propertyDescriptor.isAsContainment(), context, propertyDescriptor.getName(), type, "asContainment");
                validate(!propertyDescriptor.isHidden(), context, propertyDescriptor.getName(), type, "hidden");
                validate(!propertyDescriptor.isInspectionProperty(), context, propertyDescriptor.getName(), type, "inspection property");
                validate(!propertyDescriptor.isRequiredForInspection(), context, propertyDescriptor.getName(), type, "required for inspection");
            }
        }

        private void validate(boolean b, VerificationContext context, Object... params) {
            if (!b) {
                context.error("Property [%s] of [%s] cannot be marked as %s.", params);
            }
        }
    }
}
