/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Map;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = NotEmpty.Validator.class, type = "not-empty")
@Target(ElementType.FIELD)
public @interface NotEmpty {
    String DEFAULT_MESSAGE = "Value is required";

    String message() default DEFAULT_MESSAGE;

    public static class Validator implements PatternValidator<Object> {
        private String message = DEFAULT_MESSAGE;

        // Used only for front-end validation
        private String pattern = ".+";

        @Override
        public void validate(Object value, ValidationContext context) {
            if (value == null
                    || (value instanceof String && value == "")
                    || (value instanceof Collection && ((Collection<?>) value).isEmpty())
                    || (value instanceof Map && ((Map<?, ?>) value).isEmpty())) {
                context.error(message);
            }
        }

        public String getPattern() {
            return pattern;
        }

        public String getMessage() {
            return message;
        }
    }
}