/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.services

import java.util
import java.io.InputStream

import com.xebialabs.deployit.engine.spi.exception.DeployitException
import scala.jdk.CollectionConverters._

object ArtifactTransformer {
  implicit class EnhancedTransformationContext(transformationContext: util.Map[String, Any]) {
    def getProperty[T](name: String, extractor: PartialFunction[Any, T]): T =
      extractor
        .orElse[Any, T] { case _ => throw ArtifactTransformerException(s"Missing value for '$name' in transformer context") }
        .apply(transformationContext.get(name))
  }
}

trait ArtifactTransformer {
  def transform(source: InputStream, transformationContext: util.Map[String, Any]): InputStream

  def validate(source: InputStream, transformationContext: util.Map[String, Any]): Unit
}

class ContextInjectingArtifactTransformer(delegate: ArtifactTransformer,
                                          context: util.Map[String, Any]) extends ArtifactTransformer {
  override def transform(source: InputStream, transformationContext: util.Map[String, Any]): InputStream = {
    val newContext = context.asScala ++ transformationContext.asScala
    delegate.transform(source, newContext.asJava)
  }

  override def validate(source: InputStream, transformationContext: util.Map[String, Any]): Unit = {
    val newContext = context.asScala ++ transformationContext.asScala
    delegate.validate(source, newContext.asJava)
  }
}

case class ArtifactTransformerException(message: String) extends DeployitException(message)
