/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.lookup;

import com.xebialabs.deployit.plugin.api.udm.ExternalProperty;

import java.util.Objects;

public class LookupValueKey implements ExternalProperty {

    private String key;

    private String providerId;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    @Override
    public String toString() {
        return "!lookup '" + key + '\'' +
                " in '" + providerId + '\'';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LookupValueKey that = (LookupValueKey) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(providerId, that.providerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, providerId);
    }
}
