/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.credentials

import java.util.function.BiConsumer

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}

import scala.beans.BeanProperty

@Metadata(root = CONFIGURATION, description = "Base credentials CI")
@TypeIcon(value = "icons/types/lock.svg")
abstract class HostCredentials extends BaseConfigurationItem with Credentials {

  @Property(label = "Username", required = true)
  @BeanProperty
  var username: String = _

  @Property(password = true, label = "Password", required = false)
  @BeanProperty
  var password: String = _

  def applyProperties(consumer: BiConsumer[String, String]): Unit = {
    consumer.accept("username", getUsername)
    consumer.accept("password", getPassword)
  }

}
