/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployable;
import com.xebialabs.deployit.plugin.api.validation.FileEncodings;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.credentials.Credentials;
import com.xebialabs.deployit.plugin.proxy.ProxySettings;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@Metadata(virtual=true, description="The supertype of all DeployableArtifacts.")
public class BaseDeployableArtifact
extends BaseDeployable
implements DeployableArtifact {
    public static final String SCAN_PLACEHOLDERS_PROPERTY_NAME = "scanPlaceholders";
    private OverthereFile file;
    @Property(required=false, label="Replace Placeholders", category="Placeholders", description="Whether to scan this artifact to replace placeholders when it is imported", defaultValue="true")
    private boolean scanPlaceholders;
    @Property(required=false, label="Pre-Scanned Placeholders", category="Placeholders", description="Whether this artifact has been pre-scanned by the packager (ie. scanned for placeholders and checksum is set)", defaultValue="false")
    private boolean preScannedPlaceholders;
    @Property(required=false, category="Placeholders", description="Placeholders detected in this artifact")
    private Set<String> placeholders = new TreeSet<String>();
    @Property(required=false, category="Placeholders", description="The delimiters used indicate placeholders, defaults to '{{ }}'. This is a 5 character string with a space in the middle, the first two are the leading delimiter, the last two are the closing delimiter", defaultValue="{{ }}", hidden=true)
    @Regex(pattern=".. ..")
    private String delimiters = "{{ }}";
    @Property(hidden=true, category="Placeholders", description="Regular expression that matches file names of text files", defaultValue=".+\\.(cfg | conf | config | ini | properties | props | txt | asp | aspx | htm | html | jsf | jsp | xht | xhtml | sql | xml | xsd | xsl | xslt)")
    private String textFileNamesRegex;
    @Property(required=false, category="Placeholders", description="Regular expression that matches file names that must be excluded from scanning")
    private String excludeFileNamesRegex;
    @Property(required=false, category="Deployment", description="The checksum used to detect differences on the artifact. If not provided, it will be calculated by XL Deploy.")
    private String checksum;
    @Property(required=false, category="Placeholders", description="Specifies file encodings in this artifact. Key: regular expression matching file names; value: character set. Character set encoding is used for placeholder replacement and transcoding files to z/OS.", defaultValue=".+\\.properties:ISO-8859-1")
    @FileEncodings
    private Map<String, String> fileEncodings;
    @Property(required=false, category="Transcode", label="File Names Regex To Transcode", description="Regular expression that matches file names of text files to transcode to EBCDIC", defaultValue=".+\\.(cfg | conf | config | ini | properties | props | txt | asp | aspx | htm | html | jsf | jsp | xht | xhtml | sql | xml | xsd | xsl | xslt)")
    private String textFileNamesRegexToTranscode;
    @Property(required=false, category="Transcode", label="Exclude File Names Regex To Transcode", description="A regex of file type that needs to be ignored for transcode", defaultValue="")
    private String excludeFileNamesRegexToTranscode;
    @Property(required=false, description="The URI pointing to the (remote) location of the file this artifact represents")
    private String fileUri;
    @Property(required=false, description="Credentials of the URI.")
    private Credentials credentials;
    @Property(required=false, description="Proxy Settings for artifact location")
    private ProxySettings proxySettings;
    @Property(required=false, description="Indicates if the artifact has been rescanned", defaultValue="false")
    private boolean isRescanned;

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    @Override
    public OverthereFile getFile() {
        return this.file;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public boolean isScanPlaceholders() {
        return this.scanPlaceholders;
    }

    public void setScanPlaceholders(boolean scanPlaceholders) {
        this.scanPlaceholders = scanPlaceholders;
    }

    public boolean isPreScannedPlaceholders() {
        return this.preScannedPlaceholders;
    }

    public void setPreScannedPlaceholders(boolean preScannedPlaceholders) {
        this.preScannedPlaceholders = preScannedPlaceholders;
    }

    @Override
    public Set<String> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public void setPlaceholders(Set<String> placeholders) {
        this.placeholders = placeholders;
    }

    @Override
    public String getTextFileNamesRegex() {
        return this.textFileNamesRegex;
    }

    public void setTextFileNamesRegex(String textFileNamesRegex) {
        this.textFileNamesRegex = textFileNamesRegex;
    }

    @Override
    public String getExcludeFileNamesRegex() {
        return this.excludeFileNamesRegex;
    }

    @Override
    public Map<String, String> getFileEncodings() {
        return this.fileEncodings;
    }

    @Override
    public String getFileUri() {
        return this.fileUri;
    }

    public void setExcludeFileNamesRegex(String excludeFileNamesRegex) {
        this.excludeFileNamesRegex = excludeFileNamesRegex;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    public boolean getRescanned() {
        return this.isRescanned;
    }

    public void setRescanned(boolean rescanned) {
        this.isRescanned = rescanned;
    }

    @Override
    public String getTextFileNamesRegexToTranscode() {
        return this.textFileNamesRegexToTranscode;
    }

    public void setTextFileNamesRegexToTranscode(String textFileNamesRegexToTranscode) {
        this.textFileNamesRegexToTranscode = textFileNamesRegexToTranscode;
    }

    @Override
    public String getExcludeFileNamesRegexToTranscode() {
        return this.excludeFileNamesRegexToTranscode;
    }

    public void setExcludeFileNamesRegexToTranscode(String excludeFileNamesRegexToTranscode) {
        this.excludeFileNamesRegexToTranscode = excludeFileNamesRegexToTranscode;
    }
}

