/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import java.util.ArrayList;
import java.util.List;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.file.FileCopyStrategy;
import com.xebialabs.deployit.plugin.overthere.DefaultCopyStrategyName;
import com.xebialabs.overthere.OverthereFile;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A folder artifact that can be deployed")
public class BaseDeployableFolderArtifact extends BaseDeployableArtifact implements FolderArtifact {

    @Property(required = false, label="Default Copy Strategy", description = "Default copy strategy for this folder artifact.")
    private FileCopyStrategy defaultCopyStrategy;

    @Property(required = false, description = "Force Archive", defaultValue = "true", hidden = true)
    private boolean isForceArchive;

    public boolean isForceArchive() {
        return isForceArchive;
    }

    public void setForceArchive(boolean forceArchive) {
        isForceArchive = forceArchive;
    }
    public List<OverthereFile> getFiles() {
        List<OverthereFile> files = new ArrayList<>();
        OverthereFile folderLocation = getFile();
        if (folderLocation.exists() && folderLocation.isDirectory() && folderLocation.canRead()) {
            List<? extends OverthereFile> allFiles = folderLocation.listFiles();
            if (allFiles != null) {
                files.addAll(allFiles);
            }
        }
        return files;
    }

    public FileCopyStrategy getDefaultCopyStrategy() {
        return defaultCopyStrategy;
    }

    public void setDefaultCopyStrategy(FileCopyStrategy defaultCopyStrategy) {
        this.defaultCopyStrategy = defaultCopyStrategy;
    }

    public DefaultCopyStrategyName getDefaultCopyStrategyName() {
        return defaultCopyStrategy != null ? defaultCopyStrategy.getProperty("defaultCopyStrategy") : null;
    }

    public String getDefaultCopyStrategyNameAsValue() {
        DefaultCopyStrategyName defaultCopyStrategyName = getDefaultCopyStrategyName();
        return defaultCopyStrategyName != null ? defaultCopyStrategyName.toString() : "";
    }

}
