/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.file

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.overthere.DefaultCopyStrategyName

import java.util.function.BiConsumer
import scala.beans.BeanProperty

@Metadata(root = CONFIGURATION, label="CopyStrategy", description = "Defines a copy strategy for file folders")
@TypeIcon(value = "icons/types/udm.ConfigurationItem.svg")
class FileCopyStrategy extends BaseConfigurationItem {

  @Property(required=false, label = "Default Copy Strategy", description = "The default copy strategy will be applied in file.Folder only if no infrastructure copy strategy is defined.")
  @BeanProperty
  var defaultCopyStrategy: DefaultCopyStrategyName = _

  def applyProperties(consumer: BiConsumer[String, DefaultCopyStrategyName]): Unit = {
    consumer.accept("defaultCopyStrategy", defaultCopyStrategy)
  }
}
