package com.xebialabs.deployit.plugin.api.reflect;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class DeployableGenerator {
    public static void init() {
        generateDeployables();
    }

    static void generateDeployables() {
        List<Descriptor> generatedDeployableDescriptors = newArrayList();
        for(Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            if(descriptor.shouldGenerateDeployableType()) {
                generatedDeployableDescriptors.add(Descriptor.from(descriptor));
            }
        }

        for(Descriptor d : generatedDeployableDescriptors) {
            DescriptorRegistry.register(d);
        }
    }


}
