/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.deployment.execution;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class InterleavedPlan
implements Plan {
    private List<Delta> deltas;
    private ListMultimap<Integer, DeploymentStep> steps;

    InterleavedPlan(Delta ... deltas) {
        this.deltas = Collections.unmodifiableList(Lists.newArrayList((Object[])deltas));
        this.steps = Multimaps.unmodifiableListMultimap((ListMultimap)ArrayListMultimap.create());
    }

    InterleavedPlan(List<Delta> deltas, ListMultimap<Integer, DeploymentStep> steps) {
        this.deltas = Collections.unmodifiableList(deltas);
        this.steps = Multimaps.unmodifiableListMultimap(steps);
    }

    public List<Delta> getDeltas() {
        return this.deltas;
    }

    public ListMultimap<Integer, DeploymentStep> getStepsMap() {
        return this.steps;
    }

    @Override
    public List<DeploymentStep> getSteps() {
        TreeSet keys = new TreeSet(this.steps.keySet());
        ArrayList objects = Lists.newArrayList();
        for (Integer key : keys) {
            objects.addAll(this.steps.get((Object)key));
        }
        return objects;
    }

    @Override
    public String getType() {
        return InterleavedPlan.class.getName();
    }
}

