/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import java.util.Map;
import java.util.regex.Pattern;

@Metadata
public abstract class BaseConfigurationItem
implements ConfigurationItem,
Comparable<BaseConfigurationItem> {
    protected String id = String.valueOf(System.identityHashCode(this));
    protected Type type = Type.valueOf(this.getClass());
    protected Map<String, Object> syntheticProperties = Maps.newHashMap();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        int indexOfLastSlash = this.id.lastIndexOf(47);
        if (indexOfLastSlash > -1) {
            return this.id.substring(indexOfLastSlash + 1);
        }
        return this.id;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof BaseConfigurationItem)) {
            return false;
        }
        BaseConfigurationItem that = (BaseConfigurationItem)thatObject;
        return this.getId().equals(that.getId());
    }

    @Override
    public int compareTo(BaseConfigurationItem o) {
        return this.getId().compareTo(o.getId());
    }

    public String toString() {
        if (this.id == null) {
            return this.getClass().getName() + "[id = null]";
        }
        if (Pattern.matches("[ '\"]", this.id)) {
            return "\"" + this.id + "\"";
        }
        return this.id;
    }

    @Override
    public Map<String, Object> getSyntheticProperties() {
        return this.syntheticProperties;
    }

    @Override
    public <T> T getSyntheticProperty(String key) {
        return (T)this.syntheticProperties.get(key);
    }

    public boolean hasSyntheticProperty(String key) {
        return this.syntheticProperties.containsKey(key);
    }

    @Override
    public <T> void putSyntheticProperty(String key, T value) {
        this.syntheticProperties.put(key, value);
    }

    public void putSyntheticProperties(Map<String, String> properties) {
        this.syntheticProperties.putAll(properties);
    }

    public void setSyntheticProperties(Map<String, Object> additionalProperties) {
        this.syntheticProperties = additionalProperties;
    }
}

