package com.xebialabs.deployit.plugin.api.reflect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorHierarchyInitializer {
    public static void init() {
        buildHierachicalTree();
    }

    static void buildHierachicalTree() {
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            logger.debug("Building hierarchy for {}", descriptor);
            descriptor.initHierarchy();
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(DescriptorHierarchyInitializer.class);
}
