package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Predicate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

class SyntheticHelper {

    static String getRequiredStringAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
    }

    static String getRequiredStringAttribute(Element element, String attributeName, String additionalMessage) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided " + additionalMessage);
    }

    static Type getRequiredTypeAttribute(Element element, String attributeName) {
        Type type = getOptionalTypeAttribute(element,attributeName);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName, Type defaultValue) {
        String typeAttr = getOptionalStringAttribute(element, attributeName, null);
        Type type = defaultValue;
        if (typeAttr != null) {
            type = Type.valueOf(typeAttr);
        }
        return type;
    }
    static Type getOptionalTypeAttribute(Element element, String attributeName) {
        return getOptionalTypeAttribute(element, attributeName, null);
    }

    static boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        return Boolean.valueOf(getOptionalStringAttribute(element, attributeName, Boolean.toString(defaultValue)));
    }
    static String getOptionalStringAttribute(Element element, String attributeName, String defaultValue) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return defaultValue;
    }

    static List<Element> filterChildElementsByName(Element element, Predicate<String> matcher) {
        List<Element> children = newArrayList();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); i++) {
            if (childNodes.item(i) instanceof Element) {
                Element e = (Element) childNodes.item(i);
                if (matcher.apply(e.getNodeName())) {
                    children.add(e);
                }
            }
        }
        return children;
    }

    static <E> void forEach(Collection<E> collection, Closure<E> closure) {
        for (E e : collection) {
            closure.call(e);
        }
    }

    public static interface Closure<E> {
        void call(E e);
    }
}
