package com.xebialabs.deployit.plugin.api.udm.artifact;

import java.util.Set;

public interface SourceArtifact extends Artifact {

	Set<String> getPlaceholders();
	
	void setPlaceholders(Set<String> placeholders);

	/**
	 * Invoked when an artifact of this type is imported. After this call, the placeholders property should be filled.
	 * 
	 * @param scanner The placeholder scanner to invoke.
	 */
	void initPlaceholders(PlaceholderScanner scanner);

	String getTextFileNamesRegex();
	
}
