package com.xebialabs.deployit.plugin.api.deployment.planning;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Annotation can be added to any method of a class with a no-arg constructor.
 * The annotated method should take the following parameters:
 * <ul>
 *     <li>{@link com.xebialabs.deployit.plugin.api.deployment.specification.Deltas} The collection of Deltas that are currently being planned.</li>
 *     <li>{@link DeploymentPlanningContext} The Planning Context</li>
 * </ul>
 * The annotated method should not have a return type (void).
 */
@Retention(RUNTIME)
@Target(ElementType.METHOD)
public @interface Contributor {
}
