package com.xebialabs.deployit.plugin.api.deployment.execution;

import java.util.List;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;

public class Plans {
    public static InterleavedPlan interleaved(List<Delta> operations) {
        return new InterleavedPlan(operations);
    }

    public static InterleavedPlan interleaved(Delta... operations) {
        return new InterleavedPlan(operations);
    }

    public static ParallelPlan parallel(Plan... plans) {
        return new ParallelPlan(plans);
    }

    public static ParallelPlan parallel(List<Plan> plans) {
        return new ParallelPlan(plans);
    }

    public static SerialPlan serial(Plan... plans) {
        return new SerialPlan(plans);
    }

    public static SerialPlan serial(List<Plan> plans) {
        return new SerialPlan(plans);
    }

    public static InterleavedPlan interleaved(ListMultimap<Integer, DeploymentStep> steps) {
        return new InterleavedPlan(Lists.<Delta>newArrayList(), steps);
    }

    public static InterleavedPlanBuilder newInterleavedPlan(InterleavedPlan original) {
        return new InterleavedPlanBuilder(original);
    }

    public static class InterleavedPlanBuilder {
        private List<Delta> operations;
        private ListMultimap<Integer, DeploymentStep> steps;

        private InterleavedPlanBuilder(InterleavedPlan original) {
            operations = original.getDeltas();
            steps = ArrayListMultimap.create(original.getStepsMap());
        }

        public InterleavedPlanBuilder withStep(DeploymentStep step) {
            steps.put(step.getOrder(), step);
            return this;
        }

        public InterleavedPlanBuilder withSteps(List<DeploymentStep> steps) {
	        for (DeploymentStep step : steps) {
		        this.steps.put(step.getOrder(), step);
	        }
            return this;
        }

        public InterleavedPlanBuilder withSteps(DeploymentStep... steps) {
	        for (DeploymentStep step : steps) {
		        this.steps.put(step.getOrder(), step);
	        }
            return this;
        }

        public InterleavedPlanBuilder replaceAllSteps(ListMultimap<Integer, DeploymentStep> steps) {
            this.steps = steps;
            return this;
        }

        public InterleavedPlan build() {
            return new InterleavedPlan(operations, steps);
        }
    }
}
