package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
@Metadata(virtual = true)
public class BaseContainer extends BaseConfigurationItem implements Container {
	@Property(required = false, category = "Deployment", description = "If set, only deployables with the same tag will be automatically mapped to this container.")
	private Set<String> tags = newHashSet();

	@Override
	public Set<String> getTags() {
		return tags;
	}

	@Override
	public void setTags(Set<String> tags) {
		this.tags = tags;
	}
}
