package com.xebialabs.deployit.plugin.api.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = Regex.Validator.class, type = "regex")
@Target(ElementType.FIELD)
public @interface Regex {
	String DEFAULT_MESSAGE = "Value '%s' did not conform to pattern %s";
	String pattern();
	String message() default DEFAULT_MESSAGE;

	public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
		private String pattern;
		private String message = DEFAULT_MESSAGE;
		
		@Override
		public void validate(String value, ValidationContext context) {
			if (value != null && !Pattern.compile(pattern).matcher(value).matches()) {
				context.error(message, value, pattern);
			}
		}
	}
}