/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.ClassUtils;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.ValidationRuleConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Descriptor {
    static final String PLACEHOLDERS_FIELD = "placeholders";
    private Type type;
    private Class<? extends ConfigurationItem> clazz;
    private String description;
    private Metadata.ConfigurationItemRoot root;
    private List<Type> superclasses = Lists.newArrayList();
    private Set<Type> interfaces = Sets.newHashSet();
    private boolean virtual = false;
    private Map<String, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private Type deployableType;
    private Type containerType;
    private Type generatedDeployableType;
    private Type generatedDeployableBase;
    private String generatedDeployableDescription;
    private boolean hierarchyInitialized = false;
    private Map<String, MethodDescriptor> controlTasks = Maps.newHashMap();
    private List<Validator<ConfigurationItem>> validators = Lists.newArrayList();
    private Field syntheticPropertiesField;
    private static final Logger logger = LoggerFactory.getLogger(Descriptor.class);

    private Descriptor(Class<? extends ConfigurationItem> clazz) {
        this.type = Type.valueOf(clazz);
        this.virtual = clazz.isInterface();
        this.clazz = clazz;
    }

    private Descriptor(Type type) {
        this.type = type;
    }

    static Descriptor from(Class<? extends ConfigurationItem> clazz) {
        try {
            Descriptor descriptor = new Descriptor(clazz);
            descriptor.initMetadata();
            descriptor.scanClass();
            return descriptor;
        }
        catch (RuntimeException runtimeException) {
            throw new DescriptorException("Could not create descriptor for: " + clazz.getName(), runtimeException);
        }
    }

    private void initMetadata() {
        if (this.virtual) {
            return;
        }
        boolean bl = false;
        Annotation[] annotationArray = this.clazz.getDeclaredAnnotations();
        for (Annotation annotation : annotationArray) {
            if (!annotation.annotationType().equals(Metadata.class)) continue;
            bl = true;
        }
        Metadata metadata = (Metadata)Preconditions.checkNotNull((Object)this.clazz.getAnnotation(Metadata.class), (Object)("Class " + this.clazz.getName() + " or one of its ancestors does not have a @Metadata annotation"));
        this.description = metadata.description();
        this.root = metadata.root();
        this.virtual = bl && metadata.virtual() || Modifier.isAbstract(this.clazz.getModifiers());
    }

    private void scanClass() {
        this.findProperties();
        this.findControlTasks();
        this.findInterfaces();
        this.findValidations();
        Class<? extends ConfigurationItem> clazz = this.clazz.getSuperclass();
        if (clazz != null && ConfigurationItem.class.isAssignableFrom(clazz)) {
            Type type = Type.valueOf(clazz);
            this.addSuperClass(type);
        }
        this.initDeployableAndContainerTypes();
    }

    private void findValidations() {
        for (Annotation annotation : this.clazz.getAnnotations()) {
            if (!ValidationRuleConverter.isRule(annotation)) continue;
            Validator<?> validator = ValidationRuleConverter.makeRule(annotation);
            this.validators.add(validator);
        }
    }

    private void findControlTasks() {
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ControlTask.class)) continue;
            MethodDescriptor methodDescriptor = MethodDescriptor.from(this, method);
            this.addControlTask(methodDescriptor);
        }
    }

    private void findProperties() {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            PropertyDescriptor propertyDescriptor = PropertyDescriptor.from(this, field);
            this.addProperty(propertyDescriptor);
        }
    }

    private void findInterfaces() {
        Class<?>[] classArray = this.clazz.getInterfaces();
        ArrayList arrayList = Lists.newArrayList();
        this.findAllSuperInterfaces(classArray, arrayList);
        for (Class clazz : arrayList) {
            if (!clazz.getPackage().isAnnotationPresent(Prefix.class)) continue;
            this.addInterface(Type.valueOf(clazz));
        }
    }

    private void findAllSuperInterfaces(Class<?>[] classArray, List<Class<?>> list) {
        for (Class<?> clazz : classArray) {
            list.add(clazz);
            this.findAllSuperInterfaces(clazz.getInterfaces(), list);
        }
    }

    private void initDeployableAndContainerTypes() {
        if (Deployed.class.isAssignableFrom(this.clazz)) {
            List<Class<?>> list = ClassUtils.getActualTypeArguments(this.clazz, Deployed.class);
            Preconditions.checkArgument((list.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly a Deployable and a Container, but got %s", (Object[])new Object[]{list});
            Class<?> clazz = list.get(0);
            if (clazz != null) {
                Preconditions.checkArgument((boolean)Deployable.class.isAssignableFrom(clazz), (Object)"Expected first item to be a deployable");
                this.deployableType = Type.valueOf(clazz);
            } else {
                this.deployableType = null;
            }
            Class<?> clazz2 = list.get(1);
            if (clazz2 != null) {
                Preconditions.checkArgument((boolean)Container.class.isAssignableFrom(clazz2), (Object)"Expected second item to be a container");
                this.containerType = Type.valueOf(clazz2);
            } else {
                this.containerType = null;
            }
        } else {
            this.deployableType = null;
            this.containerType = null;
        }
    }

    static Descriptor from(Element element) {
        Type type = SyntheticHelper.getRequiredTypeAttribute(element, "type");
        Descriptor descriptor = new Descriptor(type);
        descriptor.initSynthetic(element);
        return descriptor;
    }

    private void initSynthetic(Element element) {
        this.description = SyntheticHelper.getOptionalStringAttribute(element, "description", "Description unavailable");
        this.virtual = SyntheticHelper.getOptionalBooleanAttribute(element, "virtual", false);
        Type type = SyntheticHelper.getRequiredTypeAttribute(element, "extends");
        this.addSuperClass(type);
        this.parseSyntheticDeployableAndContainerType(element);
        this.parseTypeModification(element);
        this.parseValidators(element);
    }

    private void parseValidators(Element element) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"rule")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                Descriptor.this.validators.add(ValidationRuleConverter.makeRule(element, Descriptor.this.type));
            }
        });
    }

    private void parseSyntheticDeployableAndContainerType(Element element) {
        this.deployableType = SyntheticHelper.getOptionalTypeAttribute(element, "deployable-type");
        this.containerType = SyntheticHelper.getOptionalTypeAttribute(element, "container-type");
        Iterator<Element> iterator = SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"generate-deployable"));
        if (iterator.hasNext()) {
            Element element2 = iterator.next();
            this.generatedDeployableType = SyntheticHelper.getRequiredTypeAttribute(element2, "type");
            this.generatedDeployableBase = SyntheticHelper.getRequiredTypeAttribute(element2, "extends");
            this.generatedDeployableDescription = SyntheticHelper.getOptionalStringAttribute(element2, "description", "Description unavailable");
        }
    }

    void parseTypeModification(Element element) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"property")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                String string = SyntheticHelper.getRequiredStringAttribute(element, "name");
                PropertyDescriptor propertyDescriptor = PropertyDescriptor.from(Descriptor.this, element);
                PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)Descriptor.this.properties.get(string);
                if (propertyDescriptor2 != null) {
                    propertyDescriptor.overrideWith(propertyDescriptor2);
                }
                Descriptor.this.addProperty(propertyDescriptor);
            }
        });
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"method")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                MethodDescriptor methodDescriptor = MethodDescriptor.from(Descriptor.this, element);
                Descriptor.this.verifyNewControlTask(methodDescriptor);
                Descriptor.this.addControlTask(methodDescriptor);
            }
        });
    }

    private void verifyNewControlTask(MethodDescriptor methodDescriptor) {
        if (this.controlTasks.containsKey(methodDescriptor.getName())) {
            throw new IllegalStateException("Cannot override existing Control Task [" + methodDescriptor.getName() + "] with a synthetic one.");
        }
    }

    static Descriptor from(Descriptor descriptor) {
        Descriptor descriptor2 = new Descriptor(descriptor.generatedDeployableType);
        descriptor2.addSuperClass(descriptor.generatedDeployableBase);
        descriptor2.initDeployableFromDeployed(descriptor, descriptor.generatedDeployableDescription);
        return descriptor2;
    }

    private void initDeployableFromDeployed(Descriptor descriptor, String string) {
        this.description = string == null || string.equals("Description unavailable") ? descriptor.getDescription() + " (deployable)" : string;
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            boolean bl;
            String string2 = propertyDescriptor.getName();
            boolean bl2 = string2.equals("deployable") || string2.equals("container") || string2.equals(PLACEHOLDERS_FIELD);
            PropertyKind propertyKind = propertyDescriptor.getKind();
            boolean bl3 = bl = propertyKind == PropertyKind.CI || propertyKind == PropertyKind.SET_OF_CI || propertyKind == PropertyKind.LIST_OF_CI;
            if (bl2 || bl || propertyDescriptor.isHidden()) continue;
            this.addProperty(PropertyDescriptor.generateDeployableFrom(this, propertyDescriptor));
        }
    }

    void initHierarchy() {
        if (this.hierarchyInitialized || this.superclasses.isEmpty()) {
            return;
        }
        Type type = this.superclasses.get(0);
        do {
            Descriptor descriptor;
            if ((descriptor = DescriptorRegistry.getDescriptor(type)) == null) {
                throw new IllegalStateException("Cannot build type hierarchy for " + this.getType() + " because one of its supertypes cannot be found: " + type + " not found");
            }
            if (this.root == null) {
                this.root = descriptor.getRoot();
            }
            if (this.clazz == null) {
                this.clazz = descriptor.clazz;
            }
            this.inheritPropertyDescriptors(this.properties, descriptor.properties);
            this.inheritControlTasks(this.controlTasks, descriptor.controlTasks);
            this.inheritValidators(this.validators, descriptor.validators);
            for (Type type2 : descriptor.superclasses) {
                this.addSuperClass(type2);
            }
            for (Type type2 : descriptor.interfaces) {
                this.addInterface(type2);
            }
            Type type3 = type = descriptor.superclasses.isEmpty() || descriptor.hierarchyInitialized ? null : descriptor.getSuperClasses().get(0);
            if (this.deployableType == null) {
                this.deployableType = descriptor.getDeployableType();
            }
            if (this.containerType != null) continue;
            this.containerType = descriptor.getContainerType();
        } while (type != null);
        this.syntheticPropertiesField = ReflectionUtils.searchField(this.clazz, "syntheticProperties");
        this.syntheticPropertiesField.setAccessible(true);
        this.verify();
        this.hierarchyInitialized = true;
    }

    private void verify() {
        this.verifySyntheticPropertiesField();
        this.verifyReferenceTypes();
        this.verifyNonArtifactDoesNotHavePlaceholders();
        this.verifyArtifactInterfaces();
        if (!this.isVirtual()) {
            this.verifyJavaClassIsNotAbstract();
            this.verifyDeployedHasDeployableAndContainerType();
            this.verifyHiddenRequiredPropertiesHaveDefaultValue();
            this.verifyControlTasks();
        }
    }

    private void verifySyntheticPropertiesField() {
        Preconditions.checkNotNull((Object)this.syntheticPropertiesField, (Object)"Synthetic properties field should be set");
        Preconditions.checkState((boolean)this.syntheticPropertiesField.getType().isAssignableFrom(Map.class), (String)"Synthetic properties field should be Map<String, Object>, not: %s", (Object[])new Object[]{this.syntheticPropertiesField.getType()});
    }

    private void verifyControlTasks() {
        for (MethodDescriptor methodDescriptor : this.controlTasks.values()) {
            methodDescriptor.verify();
        }
    }

    private void verifyReferenceTypes() {
        for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
            PropertyKind propertyKind = propertyDescriptor.getKind();
            if (propertyKind != PropertyKind.CI && propertyKind != PropertyKind.SET_OF_CI && propertyKind != PropertyKind.LIST_OF_CI) continue;
            Preconditions.checkState((boolean)this.isValidReferencedType(propertyDescriptor.getReferencedType()), (String)"Property %s of type %s refers to non-existing type %s", (Object[])new Object[]{propertyDescriptor.getName(), propertyDescriptor.getDeclaringDescriptor().getType(), propertyDescriptor.getReferencedType()});
        }
    }

    private boolean isValidReferencedType(Type type) {
        if (DescriptorRegistry.exists(type)) {
            return true;
        }
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            if (descriptor.getSuperClasses().contains(type)) {
                return true;
            }
            if (!descriptor.getInterfaces().contains(type)) continue;
            return true;
        }
        return false;
    }

    private void verifyNonArtifactDoesNotHavePlaceholders() {
        if (!this.isAssignableTo(Artifact.class)) {
            for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
                Preconditions.checkState((!propertyDescriptor.getName().equals(PLACEHOLDERS_FIELD) ? 1 : 0) != 0, (String)"Type %s that does not implemnt the udm.Artifact interface must not have a field called 'placeholders'", (Object[])new Object[]{this.type});
            }
        }
    }

    private void verifyArtifactInterfaces() {
        if (this.isAssignableTo(Deployable.class) && this.isAssignableTo(Artifact.class)) {
            Preconditions.checkState((boolean)this.isAssignableTo(SourceArtifact.class), (String)"Type %s that implements the udm.Deployable and udm.Artifact interface must also implement the udm.SourceArtifact interface", (Object[])new Object[]{this.type});
            Preconditions.checkState((boolean)this.isAssignableTo(DeployableArtifact.class), (String)"Type %s that implements the udm.Deployable and udm.Artifact interface must also implement the udm.DeployableArtifact interface", (Object[])new Object[]{this.type});
        }
        if (this.isAssignableTo(Deployed.class) && this.isAssignableTo(Artifact.class)) {
            Preconditions.checkState((boolean)this.isAssignableTo(DerivedArtifact.class), (String)"Type %s that implements the udm.Deployed and udm.Artifact interface must also implement the udm.DerivedArtifact interface", (Object[])new Object[]{this.type});
        }
    }

    private void verifyJavaClassIsNotAbstract() {
        Preconditions.checkState((!Modifier.isAbstract(this.clazz.getModifiers()) ? 1 : 0) != 0, (String)"Non-virtual type %s has an abstract Java class %s", (Object[])new Object[]{this.getType(), this.clazz.getName()});
    }

    private void verifyDeployedHasDeployableAndContainerType() {
        Type type = Type.valueOf(Deployed.class);
        if (this.isAssignableTo(type)) {
            Preconditions.checkState((this.getDeployableType() != null ? 1 : 0) != 0, (String)"Non-virtual type %s is a sub-type of %s but does not have a deployable-type", (Object[])new Object[]{this.getType(), type});
            Preconditions.checkState((this.getContainerType() != null ? 1 : 0) != 0, (String)"Non-virtual type %s is a sub-type of %s but does not have a container-type", (Object[])new Object[]{this.getType(), type});
        }
    }

    private void verifyHiddenRequiredPropertiesHaveDefaultValue() {
        for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
            if (!propertyDescriptor.isHidden() || !propertyDescriptor.isRequired()) continue;
            Preconditions.checkState((propertyDescriptor.getDefaultValue() != null ? 1 : 0) != 0, (String)"Hidden required property %s of non-virtual type %s must have a default value", (Object[])new Object[]{propertyDescriptor.getName(), this.getType()});
        }
    }

    private void inheritValidators(List<Validator<ConfigurationItem>> list, List<Validator<ConfigurationItem>> list2) {
        list.addAll(list2);
    }

    private void inheritControlTasks(Map<String, MethodDescriptor> map, Map<String, MethodDescriptor> map2) {
        for (Map.Entry<String, MethodDescriptor> entry : map2.entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                map.put(entry.getKey(), new MethodDescriptor(entry.getValue(), this));
                continue;
            }
            logger.warn("Not inheriting ControlTask [{}] on [{}]", new Object[]{entry.getValue().getFqn(), this.type});
        }
    }

    private void inheritPropertyDescriptors(Map<String, PropertyDescriptor> map, Map<String, PropertyDescriptor> map2) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap(map);
        map.clear();
        for (Map.Entry<String, PropertyDescriptor> entry : map2.entrySet()) {
            if (!linkedHashMap.containsKey(entry.getKey())) {
                map.put(entry.getKey(), new PropertyDescriptor(entry.getValue(), this));
                continue;
            }
            ((PropertyDescriptor)linkedHashMap.get(entry.getKey())).overrideWith(entry.getValue());
        }
        map.putAll(linkedHashMap);
    }

    private void addSuperClass(Type type) {
        this.superclasses.add(type);
        DescriptorRegistry.registerSubtype(type, this.type);
    }

    private void addInterface(Type type) {
        DescriptorRegistry.registerSubtype(type, this.type);
        this.interfaces.add(type);
    }

    private void addProperty(PropertyDescriptor propertyDescriptor) {
        this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
    }

    private void addControlTask(MethodDescriptor methodDescriptor) {
        this.controlTasks.put(methodDescriptor.getName(), methodDescriptor);
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.properties.values();
    }

    public PropertyDescriptor getPropertyDescriptor(String string) {
        return this.properties.get(string);
    }

    public MethodDescriptor getControlTask(String string) {
        return this.controlTasks.get(string);
    }

    public Collection<MethodDescriptor> getControlTasks() {
        return this.controlTasks.values();
    }

    public boolean isAssignableTo(Class<?> clazz) {
        return this.isAssignableTo(Type.valueOf(clazz));
    }

    public boolean isAssignableTo(Type type) {
        return this.type.isSubTypeOf(type) || this.type.equals(type);
    }

    public List<Type> getSuperClasses() {
        return this.superclasses;
    }

    public Set<Type> getInterfaces() {
        return this.interfaces;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean areEqual(ConfigurationItem configurationItem, ConfigurationItem configurationItem2) {
        return this.areEqual(configurationItem, configurationItem2, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem configurationItem, ConfigurationItem configurationItem2, Set<String> set) {
        if (configurationItem == null) {
            return configurationItem2 == null;
        }
        if (!this.getType().equals(configurationItem.getType()) || !this.getType().equals(configurationItem2.getType())) {
            return false;
        }
        if (!set.add(configurationItem.getId())) {
            return true;
        }
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (propertyDescriptor.areEqual(configurationItem, configurationItem2, set)) continue;
            return false;
        }
        return true;
    }

    boolean shouldGenerateDeployableType() {
        return this.generatedDeployableType != null;
    }

    public <T extends ConfigurationItem> T newInstance() {
        if (this.virtual) {
            throw new IllegalArgumentException("Cannot instantiate class for " + this.type + " because it is virtual");
        }
        try {
            Field field = ReflectionUtils.searchField(this.clazz, "type");
            field.setAccessible(true);
            ConfigurationItem configurationItem = this.clazz.newInstance();
            field.set(configurationItem, this.type);
            this.prefillDefaultProperties(configurationItem);
            return (T)configurationItem;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), illegalAccessException);
        }
    }

    private <T extends ConfigurationItem> void prefillDefaultProperties(T t) {
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (propertyDescriptor.getDefaultValue() != null) {
                propertyDescriptor.set(t, propertyDescriptor.getDefaultValue());
                continue;
            }
            propertyDescriptor.set(t, propertyDescriptor.emptyValue());
        }
    }

    public String toString() {
        return "Descriptor[" + this.type + "]";
    }

    public Type getDeployableType() {
        return this.deployableType;
    }

    public Type getContainerType() {
        return this.containerType;
    }

    Field getSyntheticPropertiesField() {
        return this.syntheticPropertiesField;
    }

    public List<ValidationMessage> validate(final ConfigurationItem configurationItem) {
        final ArrayList arrayList = Lists.newArrayList();
        for (PropertyDescriptor object : this.properties.values()) {
            object.validate(configurationItem, arrayList);
        }
        for (Validator validator : this.validators) {
            validator.validate(configurationItem, new ValidationContext(){

                @Override
                public void error(String string, Object ... objectArray) {
                    arrayList.add(new ValidationMessage(configurationItem.getId(), null, String.format(string, objectArray)));
                }
            });
        }
        return arrayList;
    }

    private static class DescriptorException
    extends RuntimeException {
        public DescriptorException(String string, RuntimeException runtimeException) {
            super(string, runtimeException);
        }
    }
}

