/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassUtils {
    ClassUtils() {
    }

    static <S> List<Class<? extends S>> getSuperclassChain(Class<? extends S> clazz, Class<S> clazz2) {
        Set<List<Class<S>>> set = ClassUtils.getSuperclassChainsInternal(clazz, clazz2, true);
        return set.isEmpty() ? null : set.iterator().next();
    }

    private static <S> Set<List<Class<? extends S>>> getSuperclassChainsInternal(Class<? extends S> clazz, Class<S> clazz2, boolean bl) {
        Preconditions.checkNotNull(clazz, (Object)"'clazz' and 'superclass' may not be non-null");
        Preconditions.checkNotNull(clazz2, (Object)"'clazz' and 'superclass' may not be non-null");
        if (!clazz2.isAssignableFrom(clazz)) {
            return Collections.emptySet();
        }
        return ClassUtils.getSuperclassSubchains(clazz, clazz2, bl, clazz2.isInterface());
    }

    private static <S> Set<List<Class<? extends S>>> getSuperclassSubchains(Class<? extends S> clazz, Class<S> clazz2, boolean bl, boolean bl2) {
        if (clazz.equals(clazz2)) {
            LinkedList<Class<S>> linkedList = new LinkedList<Class<S>>();
            linkedList.add(clazz);
            return Collections.singleton(linkedList);
        }
        HashSet hashSet = new HashSet();
        Class<S> clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            hashSet.add(clazz3);
        }
        if (bl2) {
            hashSet.addAll(Arrays.asList(clazz.getInterfaces()));
        }
        HashSet hashSet2 = new HashSet();
        for (Class clazz4 : hashSet) {
            Set<List<Class<S>>> set = ClassUtils.getSuperclassSubchains(clazz4, clazz2, bl, bl2);
            if (set.isEmpty()) continue;
            if (bl) {
                ClassUtils.addSubchain(hashSet2, clazz, set.iterator().next());
                return hashSet2;
            }
            for (List list : set) {
                ClassUtils.addSubchain(hashSet2, clazz, list);
            }
        }
        return hashSet2;
    }

    private static <T> void addSubchain(Set<List<Class<? extends T>>> set, Class<? extends T> clazz, List<Class<? extends T>> list) {
        list.add(0, clazz);
        set.add(list);
    }

    static <S> List<Class<?>> getActualTypeArguments(Class<? extends S> clazz, Class<S> clazz2) {
        Preconditions.checkNotNull(clazz2, (Object)"All arguments must be non-null");
        Preconditions.checkNotNull(clazz, (Object)"All arguments must be non-null");
        if (!clazz2.isAssignableFrom(clazz)) {
            return null;
        }
        TypeVariable<Class<S>>[] typeVariableArray = clazz2.getTypeParameters();
        if (typeVariableArray.length == 0) {
            return new ArrayList(0);
        }
        HashMap hashMap = new HashMap(typeVariableArray.length);
        List<Class<S>> list = ClassUtils.getSuperclassChain(clazz, clazz2);
        assert (list != null) : Arrays.asList(clazz2, clazz);
        for (int i = 0; i < list.size() - 1; ++i) {
            ClassUtils.collectAssignments(list.get(i), list.get(i + 1), hashMap);
        }
        return ClassUtils.getActualAssignments(typeVariableArray, hashMap);
    }

    private static void collectAssignments(Class<?> clazz, Class<?> clazz2, Map<TypeVariable<?>, Class<?>> map) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz2.getTypeParameters();
        if (typeVariableArray.length == 0) {
            return;
        }
        Type[] typeArray = ClassUtils.getActualTypeAttributes(clazz, clazz2);
        assert (typeVariableArray.length == typeArray.length) : Arrays.asList(typeVariableArray, map);
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            if (type instanceof Class) {
                map.put(typeVariableArray[i], (Class)type);
                continue;
            }
            if (type instanceof ParameterizedType) {
                assert (((ParameterizedType)type).getRawType() instanceof Class) : type;
                map.put(typeVariableArray[i], (Class)((ParameterizedType)type).getRawType());
                continue;
            }
            assert (type instanceof TypeVariable) : type;
            if (!map.containsKey(type)) continue;
            map.put(typeVariableArray[i], map.get(type));
        }
    }

    private static Type[] getActualTypeAttributes(Class<?> clazz, Class<?> clazz2) {
        Type type = ClassUtils.tryGetGenericSupertype(clazz, clazz2);
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : clazz2.getTypeParameters();
    }

    private static Type tryGetGenericSupertype(Class<?> clazz, Class<?> clazz2) {
        if (!clazz2.isInterface()) {
            return clazz.getGenericSuperclass();
        }
        Type[] typeArray = clazz.getGenericInterfaces();
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(clazz2)) {
                return type;
            }
            assert (type instanceof Class) : type;
            if (!type.equals(clazz2)) continue;
            return type;
        }
        throw new AssertionError((Object)("Unable to find generic superclass information for class '" + clazz + "' and superclass/-interface '" + clazz2 + "'"));
    }

    private static List<Class<?>> getActualAssignments(TypeVariable<?>[] typeVariableArray, Map<TypeVariable<?>, Class<?>> map) {
        int n = typeVariableArray.length;
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(map.get(typeVariableArray[i]));
        }
        return arrayList;
    }
}

