/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DescriptorRegistry {
    private static final Map<Type, Descriptor> descriptors = Maps.newHashMap();
    private static final Multimap<Type, Type> subtypes = HashMultimap.create();
    private static Logger logger = LoggerFactory.getLogger(DescriptorRegistry.class);

    static void register(Class<? extends ConfigurationItem> clazz) {
        Descriptor descriptor = Descriptor.from(clazz);
        logger.debug("Found ConfigurationItem: {}", (Object)descriptor);
        DescriptorRegistry.register(descriptor);
    }

    static void register(Descriptor descriptor) {
        Preconditions.checkState((!descriptors.containsKey(descriptor.getType()) ? 1 : 0) != 0, (String)"The type [%s] is already registered in Deployit.", (Object[])new Object[]{descriptor.getType()});
        descriptors.put(descriptor.getType(), descriptor);
    }

    static void registerSyntheticTypeDefinition(Element element) {
        Descriptor descriptor = Descriptor.from(element);
        logger.debug("Found ConfigurationItem: {}", (Object)descriptor);
        DescriptorRegistry.register(descriptor);
    }

    static void registerSyntheticTypeModification(Element element) {
        String string = SyntheticHelper.getRequiredStringAttribute(element, "type");
        Descriptor descriptor = DescriptorRegistry.getDescriptor(string);
        descriptor.parseTypeModification(element);
    }

    static void registerSubtype(Type type, Type type2) {
        subtypes.put((Object)type, (Object)type2);
    }

    public static Collection<Descriptor> getDescriptors() {
        return descriptors.values();
    }

    public static Collection<Type> getSubtypes(Type type) {
        return subtypes.get((Object)type);
    }

    public static Descriptor getDescriptor(String string) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(string));
    }

    public static Descriptor getDescriptor(String string, String string2) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(string, string2));
    }

    public static Descriptor getDescriptor(Type type) {
        Preconditions.checkState((!descriptors.isEmpty() ? 1 : 0) != 0, (Object)"DescriptorRegistry not booted");
        Preconditions.checkArgument((boolean)DescriptorRegistry.exists(type), (String)"Unknown type [%s]", (Object[])new Object[]{type});
        return descriptors.get(type);
    }

    public static void putDescriptor(Descriptor descriptor) {
        descriptors.put(descriptor.getType(), descriptor);
    }

    public static boolean exists(Type type) {
        return descriptors.containsKey(type);
    }
}

