/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Metadata(description="A group where middleware CI's can be added, can serve as a target for a deployment.", root=Metadata.ConfigurationItemRoot.ENVIRONMENTS)
public class Environment
extends BaseConfigurationItem {
    @Property(required=false)
    private Set<Container> members = Sets.newHashSet();
    @Property(required=false)
    private List<Dictionary> dictionaries = Lists.newArrayList();

    public Environment() {
    }

    public Environment(Container ... containerArray) {
        HashSet hashSet = Sets.newHashSet();
        for (Container container : containerArray) {
            hashSet.add(container);
        }
        this.setMembers(hashSet);
    }

    public Set<Container> getMembers() {
        return this.members;
    }

    public <T extends Serializable> Set<T> getMembersOfType(Class<T> clazz) {
        HashSet<Container> hashSet = new HashSet<Container>();
        for (Container container : this.getMembers()) {
            if (!clazz.isInstance(container)) continue;
            hashSet.add(container);
        }
        return hashSet;
    }

    public void setMembers(Set<Container> set) {
        this.members = set;
    }

    public void addMember(Container container) {
        this.members.add((Container)Preconditions.checkNotNull((Object)container));
    }

    public List<Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    public void setDictionaries(List<Dictionary> list) {
        this.dictionaries = list;
    }
}

