package com.xebialabs.deployit.plugin.api.deployment.specification;

import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

import java.io.Serializable;
import java.util.List;

/**
 * The specification of what should happen on the target environment in order to deploy this {@link DeployedApplication}
 */
public interface DeltaSpecification extends Serializable {

    /**
     * The operation that is being executed on the {@link DeployedApplication}.
     *
     * @return the operation
     */
    Operation getOperation();

    /**
     * The {@link DeployedApplication} that is being replaced with this (un)deployment.
     * Is <code>null</code> when this is an initial deployment.
     *
     * @return the previous version of the DeployedApplication
     */
    DeployedApplication getPreviousDeployedApplication();

    /**
     * The {@link DeployedApplication} that is the subject of the current (un)deployment.
     * <p/>
     * <em>Note: </em> From Deployit 4.0 onwards this will return <code>null</code> when an undeployment is being planned, similar to {@link Delta}.
     *
     * @return the DeployedApplication
     */
    DeployedApplication getDeployedApplication();

    /**
     * The {@link Delta}s that were calculated for this deployment
     *
     * @return the list of {@link Delta}
     */
    List<Delta> getDeltas();

}
