package com.xebialabs.deployit.plugin.api.flow;

import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;

public interface ExecutionContext {
    /**
     * Logs a line of output. If this step is executing a command, this would be the output that is sent to the {@link System#setOut(java.io.PrintStream)
     * standard output stream}.
     *
     * @param output
     *            the log line to be written.
     */
    void logOutput(String output);

    /**
     * Logs a line of error output. If this step is executing a command, this would be the output that is sent to the {@link System#setErr(java.io.PrintStream)
     * standard error stream}.
     *
     * @param error
     *            the error line to be written.
     */
    void logError(String error);

    /**
     * Logs a line and an exception to the error output .
     *
     * @param error
     *            the error to be written.
     * @param t
     *            the exception to be logged too
     */
    void logError(String error, Throwable t);

    /**
     * Returns the execution context attribute with the given name, or <tt>null</tt> if there is no attribute by that name.
     *
     * @param name
     *            the name of the attribute
     * @return the value of the attribute, or <tt>null</tt> if there is no attribute by that name.
     */
    Object getAttribute(String name);

    /**
     * Stores an attribute in the execution context. This attribute will be available while the deployment plan is executing, until it is stopped or finished.
     *
     * @param name
     *            the name of the attribute
     * @param value
     *            the value of the attribute
     */
    void setAttribute(String name, Object value);

    InspectionContext getInspectionContext();
}
