package com.xebialabs.deployit.plugin.api.flow;

import java.io.Serializable;

/**
 * A Step that can be executed for either Inspection or Deployment.
 */
public interface Step extends Serializable {

    /**
     * The default step order.
     */
    int DEFAULT_ORDER = 50;

    /**
     * The order of the step in the step list.
     * @return the order.
     */
    int getOrder();

    /**
     * Returns a description of what this step will really do on execution.
     *
     * @return the description.
     */
    String getDescription();

    /**
     * @param ctx Context info required to execute the step.
     * @return exit code of the execution, successful, failed or paused.
     * @throws Exception Any type of exception can be thrown,
     *                   this to prevent implementors of having to wrap any non-runtime exceptions.
     */
    StepExitCode execute(ExecutionContext ctx) throws Exception;
}
