package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.List;

public interface PropertyDescriptor {
    String getName();

    String getDescription();

    boolean isAsContainment();

    String getCategory();

    String getLabel();

    boolean isPassword();

    boolean isRequired();

    Property.Size getSize();

    PropertyKind getKind();

    List<String> getEnumValues();

    Type getReferencedType();

    Object getDefaultValue();

    boolean isHidden();

    Object get(ConfigurationItem item);

    void set(ConfigurationItem item, Object value);

    boolean areEqual(ConfigurationItem item, ConfigurationItem other);

    boolean isInspectionProperty();

    boolean isRequiredForInspection();

    boolean isTransient();

    String getFqn();

    @Override
    String toString();
}
