package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import java.io.Serializable;
import java.util.Map;

/**
 * Base interface of all configuration item types.
 * 
 * We required the following contract: - The Type of a ConfigurationItem should be stored in a field called 'type'.
 */
public interface ConfigurationItem extends Serializable {

    static final String TYPE_FIELD = "type";
    static final String SYNTHETIC_PROPERTIES_FIELD = "syntheticProperties";

    String getId();

    void setId(String id);

    String getName();

    Type getType();

    @Deprecated
    Map<String, Object> getSyntheticProperties();

    @Deprecated
    <T> T getSyntheticProperty(String key);

    @Deprecated
    <T> void putSyntheticProperty(String key, T value);

    <T> T getProperty(String key);

    boolean hasProperty(String key);

    <T> void setProperty(String key, T value);
}
