package com.xebialabs.deployit.plugin.api.udm;


import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

import static com.google.common.collect.Sets.newHashSet;

/**
 * A deployment of a {@link DeploymentPackage} on an {@link Environment}.
 */
@SuppressWarnings("serial")
@Metadata(description = "A deployment of an application package or a deployable artifact to a middleware CI or an environment.")
public class DeployedApplication extends BaseConfigurationItem {

    @Property(description = "The package that has been deployed to the environment")
    private Version version;

    @Property(asContainment = true)
    private Environment environment;

    @SuppressWarnings("rawtypes")
    @Property(description = "The deployed items that have been deployed to the environment")
    private Set<Deployed> deployeds = newHashSet();

    @Property(description = "The orchestrator that is used to deploy the application", defaultValue = "default")
    private String orchestrator;
    
    public DeployedApplication() {
        // Needed for reflection.
    }

    public DeployedApplication(Version version, Environment environment) {
        this.version = version;
        this.environment = environment;
    }

    public Version getVersion() {
        return version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Environment getEnvironment() {
        return environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @SuppressWarnings("rawtypes")
    public Set<Deployed> getDeployeds() {
        return deployeds;
    }

    @SuppressWarnings("rawtypes")
    public void setDeployeds(Set<Deployed> deployeds) {
        this.deployeds = deployeds;
    }

    @SuppressWarnings("rawtypes")
    public void addDeployed(Deployed deployed) {
        this.deployeds.add(deployed);
    }

    @SuppressWarnings("rawtypes")
    public void addDeployeds(Deployed... deployeds) {
        this.deployeds.addAll(Arrays.asList(deployeds));
    }

    @SuppressWarnings("rawtypes")
    public void addDeployeds(Collection<Deployed> deployeds) {
        this.deployeds.addAll(deployeds);
    }

    public String getOrchestrator() {
        return orchestrator;
    }

    public void setOrchestrator(String orchestrator) {
        this.orchestrator = orchestrator;
    }
}
